import numpy as np
import matplotlib
matplotlib.use('TkAgg')
import matplotlib.pyplot as plt
import torch
import sys

import argparse

from scipy.stats import norm



isi16dB_isi14dB_finetuneOff = [0.748801, 0.74916, 0.749936, 0.750106, 0.750351, 0.750091, 0.752642, 0.751939, 0.750997, 0.749062]
isi16dB_isi14dB_finetuneOn = [3e-06, 0.0, 3e-06, 7.3e-05, 0.000764, 0.006346, 0.029005, 0.082368, 0.158022, 0.239094]
isi14dB_finetuneOff = [0.0, 0.0, 0.0, 3e-06, 0.000259, 0.004161, 0.025763, 0.080824, 0.162001, 0.248061]

isi14dB_isi12dB_finetuneOff = [0.0, 2e-06, 1e-05, 0.000128, 0.000912, 0.005825, 0.024762, 0.070225, 0.141615, 0.222793]
isi12dB_finetuneOff = [0.0, 0.0, 0.0, 2e-06, 9.2e-05, 0.002096, 0.015709, 0.057654, 0.128958, 0.212196]

snr30_12 = np.arange(30,10,-2)


plt.figure("14dB")
plt.xlabel('SNR (dB)',fontsize=13)
plt.xticks(fontsize=13)
plt.ylabel('BER ',fontsize=13)
#plt.ylim([0.8,10])
plt.yscale('log')
plt.grid(True)
	
plt.plot(snr30_12, isi16dB_isi14dB_finetuneOff, '-o',label='16dB->14dB, finetuneOff')
plt.plot(snr30_12, isi16dB_isi14dB_finetuneOn, '-o',label='16dB->14dB, finetuneOn')
plt.plot(snr30_12, isi14dB_finetuneOff, '-o',label='14dB, finetuneOff')

plt.legend(loc='best')

plt.figure("12dB")
plt.xlabel('SNR (dB)',fontsize=13)
plt.xticks(fontsize=13)
plt.ylabel('BER ',fontsize=13)
#plt.ylim([0.8,10])
plt.yscale('log')
plt.grid(True)
	
plt.plot(snr30_12, isi14dB_isi12dB_finetuneOff, '-o',label='16dB->14dB, finetuneOff')
plt.plot(snr30_12, isi12dB_finetuneOff, '-o',label='14dB, finetuneOff')

plt.legend(loc='best')


plt.show()
